/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.utility;

import com.google.common.collect.Maps;
import io.leangen.geantyref.TypeToken;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.kyori.adventure.pointer.Pointer;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.pointer.Pointers;
import org.jetbrains.annotations.NotNull;

public final class Context
implements PrettyPrinter.IPrettyPrintable,
Pointered {
    private final Map<TypeToken<?>, Object> context = Maps.newHashMap();
    private Pointers pointers = Pointers.empty();

    public static Context empty() {
        return new Context();
    }

    public static <T> Context of(Class<T> type, T value) {
        return new Context().append(type, value);
    }

    public static <T> Context of(TypeToken<T> type, T value) {
        return new Context().append(type, value);
    }

    public static <T> Context of(Pointer<T> pointer, T value) {
        return new Context().pointer(pointer, value);
    }

    public Context with(Context other) {
        this.context.putAll(other.context);
        return this;
    }

    public <T> Context append(Class<T> type, T value) {
        return this.append(TypeToken.get(type), value);
    }

    public <T> Context append(TypeToken<T> type, T value) {
        this.context.put(type, value);
        return this;
    }

    public <T> Context pointer(Pointer<T> pointer, T value) {
        this.pointers = (Pointers)((Pointers.Builder)this.pointers.toBuilder()).withStatic(pointer, value).build();
        return this;
    }

    public <T> Context pointer(Pointer<T> pointer, Supplier<T> supplier) {
        this.pointers = (Pointers)((Pointers.Builder)this.pointers.toBuilder()).withDynamic(pointer, supplier).build();
        return this;
    }

    public boolean has(Class<?> type) {
        return this.has(TypeToken.get(type));
    }

    public boolean has(TypeToken<?> type) {
        return this.context.containsKey(type);
    }

    public boolean has(Pointer<?> pointer) {
        return this.pointers.supports(pointer);
    }

    public <T> Optional<T> request(Class<T> type) {
        return this.request(TypeToken.get(type));
    }

    public <T> Optional<T> request(TypeToken<T> type) {
        return Optional.ofNullable(this.context.get(type)).map(value -> value);
    }

    public <T> Optional<T> request(Pointer<T> pointer) {
        return this.pointers.get(pointer);
    }

    public <T> T require(Class<T> type) throws NoSuchElementException {
        return this.require(TypeToken.get(type));
    }

    public <T> T require(TypeToken<T> type) throws NoSuchElementException {
        return this.request(type).orElseThrow(() -> new NoSuchElementException("Missing Type: " + type.getType().getTypeName()));
    }

    public <T> T require(Pointer<T> pointer) throws NoSuchElementException {
        return this.request(pointer).orElseThrow(() -> new NoSuchElementException("Missing pointer: " + String.valueOf(pointer.key())));
    }

    public int size() {
        return this.context.size();
    }

    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    @Override
    public void print(PrettyPrinter printer) {
        for (TypeToken<?> typing : this.context.keySet()) {
            printer.add(typing.getType().getTypeName());
        }
    }

    @NotNull
    public Pointers pointers() {
        return this.pointers;
    }
}

